@extends('layouts.app')

@section('title', 'Admin Settings')

@section('content')
<div class="admin-settings">
    <div class="container">
        <h1>Settings</h1>
        
        <form method="POST" action="{{ route('admin.settings.update') }}" enctype="multipart/form-data" class="settings-form">
            @csrf
            
            <div class="settings-section">
                <h2>General Settings</h2>
                
                <div class="form-group">
                    <label for="site_name">Site Name</label>
                    <input type="text" id="site_name" name="site_name" value="{{ $settings['site_name'] }}" required>
                </div>

                <div class="form-group">
                    <label for="timezone">Timezone</label>
                    <select id="timezone" name="timezone" required>
                        @php
                            $timezones = timezone_identifiers_list();
                        @endphp
                        @foreach($timezones as $tz)
                            <option value="{{ $tz }}" {{ $settings['timezone'] == $tz ? 'selected' : '' }}>{{ $tz }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="logo">Logo</label>
                    @if($settings['logo'])
                        <div class="current-logo">
                            <img src="{{ asset('storage/' . $settings['logo']) }}" alt="Current Logo" style="max-width: 200px; margin-bottom: 10px;">
                        </div>
                    @endif
                    <input type="file" id="logo" name="logo" accept="image/*">
                    <small>Upload a new logo (Max 2MB)</small>
                </div>
            </div>

            <div class="settings-section">
                <h2>SEO Settings</h2>
                
                <div class="form-group">
                    <label for="meta_title">Meta Title</label>
                    <input type="text" id="meta_title" name="meta_title" value="{{ $settings['meta_title'] }}">
                </div>

                <div class="form-group">
                    <label for="meta_description">Meta Description</label>
                    <textarea id="meta_description" name="meta_description" rows="3">{{ $settings['meta_description'] }}</textarea>
                </div>
            </div>

            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Save Settings</button>
            </div>
        </form>
    </div>
</div>
@endsection

